/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.settings.user.ObjectLockingSettingsBean;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.settings.user.ObjectLockingSettings;
import com.ibm.hwmca.fw.settings.user.UserSettingsErrorIds;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;

public class ObjectLockingSettingsTasklet
extends PanelTasklet
implements UserSettingsErrorIds {
    private static final String TRACE_MASKT = "HUSRETMT";
    private static final String TRACE_MASKF = "HUSRETMF";
    private static final String TRACE_MASKD = "HUSRETMD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.settings.user.res.ObjectLockingSettingsRes";
    private static final String PANEL_NAME = "ObjectLockingPanel";
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "ObjectLocking");
    ObjectLockingSettings settings = ObjectLockingSettings.getObjectLockingSettings();

    public ObjectLockingSettingsTasklet() {
        Trace.trace(TRACE_MASKT, "<> ObjectLockingSettingsTasklet.ObjectLockingSettingsTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ObjectLockingSettingsTasklet.service()");
        try {
            if (request.isInitialRequest()) {
                this.serviceInitialRequest(request, response);
            } else if (request.isDisposed() || request.isCanceled()) {
                Trace.trace(TRACE_MASKF, "   terminating the tasklet");
                response.terminate();
            } else {
                String requestType = (String)request.getData("request");
                if (requestType == null) {
                    Trace.trace(TRACE_MASKF, "   request is null, terminating the tasklet");
                    response.terminate();
                } else if (requestType.equals("update")) {
                    this.serviceUpdateSettings(request, response);
                } else if (requestType.equals("defaults")) {
                    this.serviceGetDefaultSettings(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "   unknown requestType, terminating the tasklet");
                    response.terminate();
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "   exception during service: " + exc);
            if (exc instanceof TaskletException) {
                throw (TaskletException)exc;
            }
            throw new TaskletException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- ObjectLockingSettingsTasklet.service()");
    }

    private void serviceInitialRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingsTasklet.serviceInitialRequest()");
        response.replace(AUIML_FILE_NAME, PANEL_NAME, new ObjectLockingSettingsBean(this.settings.getLock(), this.settings.getRelock()));
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingsTasklet.serviceInitialRequest()");
    }

    private void serviceUpdateSettings(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingsTasklet.serviceUpdateSettings()");
        Boolean lock = (Boolean)request.getData("lock");
        Boolean relock = (Boolean)request.getData("relock");
        boolean oldLock = this.settings.getLock();
        this.settings.setLock(lock);
        this.settings.setRelock(relock);
        this.settings.store();
        if (dataRepApp.isDataRepEnabled()) {
            String sourceDataKey = new ObjectLockingSettings.SaveRestore().getCustomDataKey();
            dataRepApp.updateCustomDataLevel(sourceDataKey);
            dataRepApp.displayCustDataWarning(sourceDataKey, this);
        }
        response.noAction();
        if (this.settings.getLock() && !oldLock) {
            ObjectLockingSettings.lockAll();
        }
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingsTasklet.serviceUpdateSettings()");
    }

    private void serviceGetDefaultSettings(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ObjectLockingSettingsTasklet.serviceGetDefaultSettings()");
        ObjectLockingSettings defaults = ObjectLockingSettings.getDefault();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("lock", defaults.getLock());
        map.put("relock", defaults.getRelock());
        response.update("com.ibm.hwmca.base.settings.user.ObjectLockingSettingsBean", map);
        Trace.trace(TRACE_MASKF, "<- ObjectLockingSettingsTasklet.serviceGetDefaultSettings()");
    }

    public void logException(Throwable thr) {
        Trace.trace(TRACE_MASKF, " Error, caught exception " + thr);
        new FrameworkLog(classLogInfo, 1986, thr).log();
    }
}

